<?php

namespace App\Http\Controllers\API\v1;

use App\Models\User;
// use App\Http\Resources\UserResource;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use League\OAuth2\Server\Exception\OAuthServerException;
use Psr\Http\Message\ServerRequestInterface;
use App\Http\Resources\AuthResource;
use Response;
use Hash;
use Log;

class AccessTokenController extends \Laravel\Passport\Http\Controllers\AccessTokenController
{    
    /**
     * issueToken
     *
     * @param  mixed $request
     * @return void
     */
    public function issueToken(ServerRequestInterface $request)
    {        
        
        try {
            
            if($request->getParsedBody()['grant_type'] == "refresh_token"){
                
                $tokenResponse = parent::issueToken($request);
                $content = $tokenResponse->getContent();
                //convert json to array
                $data = json_decode($content, true);
                if(isset($data["error"]))
                    throw new OAuthServerException('The user credentials were incorrect.', 6, 'invalid_credentials', 409);
                
                return Response::json(array('access_token' => $data['access_token'], 'refresh_token' => $data['refresh_token'], 'expires_in' => $data['expires_in']));            
            }

            //get username (default is :email)
            $username = $request->getParsedBody()['username'];

            //get user
            $user = User::where('email', '=', $username)->firstOrFail();            
            // $user = new UserResource($user);

            //issuetoken
            $tokenResponse = parent::issueToken($request);

            //convert response to json string
            $content = $tokenResponse->getContent();

            //convert json to array
            $data = json_decode($content, true);

            if(isset($data["error"]))
                throw new OAuthServerException('The user credentials were incorrect.', 6, 'invalid_credentials', 409);

            //add access token to user
            $user = new AuthResource($user);
            $tokens = collect($data);
            // $user->put('access_token', $data['access_token']);
            // $user->put('expires_in', $data['expires_in']);
            // $user->put('refresh_token', $data['refresh_token']);

            return Response::json(array('user' => $user, 'access_token' => $data['access_token'], 'refresh_token' => $data['refresh_token'], 'expires_in' => $data['expires_in']));            
        }
        catch (ModelNotFoundException $e) { // email notfound
            //return error message
            // $e->getMessage()
            return Response::json(array('message' => 'Invalid login details', 'error' => $e->getMessage()), 409);
        }
        catch (OAuthServerException $e) { //password not correct..token not granted
            //return error message
            // $e->getMessage()
            return Response::json(array('message' => 'Invalid login details', 'error' => $e->getMessage()), 409);
        }
        catch (Exception $e) {
            ////return error message
            return Response::json(array('message' => 'Invalid login details', 'error' => $e->getMessage()), 409);
        }
    }
}
