<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Attendance;
use App\Models\Student;
use App\Models\Staff;
use App\Http\Resources\AttendanceResource;
use Carbon\Carbon;
use DB;

class AttendanceController extends Controller
{
    /**
     * get
     *
     * @param  mixed $request
     * @param  mixed $month
     * @return void
     */
    public function get(Request $request, $date, $offset, $page_size){

        $campus = $request->campus ?? null;        
        $keywords = $request->keywords ?? null;             

        if($request->type == 'staff'){
            $query = Staff::whereHas('user', function($u){
                            $u->where('super_admin', '<>', 1);
                        })
                        ->orWhereDoesntHave('user');
            if($campus){
                $query = $query->where('campus_id', $campus);
            }
            
            if($keywords){
                $query = $query->where(function($qq) use ($keywords){
                    $qq->where(DB::raw("concat(first_name, ' ', last_name)"), 'LIKE', "%".$keywords."%");                            
                });
            }

        }else{
            $class = $request->class ?? null;
            $section = $request->section ?? null;            
            $query = Student::query();

            if($class){
                $query = $query->where('grade_id', $class);
            }
            if($section){
                $query = $query->where('section_id', $section);            
            }
            if($campus){
                $query = $query->where('campus_id', $campus);
            }
            
            if($keywords){
                $query = $query->where(function($qq) use ($keywords){
                        $qq->where(DB::raw("concat(first_name, ' ', last_name)"), 'LIKE', "%".$keywords."%")
                            ->orWhere('guardian_name', 'like', '%'. $keywords. '%');
                            
                });
            }
        }
        
        $total = $query->count();    
        // $query = $query->get()->sortBy('total_balance');
        // $query = $query->orderByRaw('total_balance DESC');
        $attendance = $query->skip($offset)->take($page_size)->get();

        return response()->json(['attendance' => AttendanceResource::collection($attendance), 'total' => $total]);

    }
    
    /**
     * update
     *
     * @param  mixed $request
     * @param  mixed $id
     * @return void
     */
    public function update(Request $request, $id){

        $type = $request->type === 'staff' ? 'App\Models\Staff' : 'App\Models\Student';
        $date = Carbon::parse($request->date);

        $prev_attendance = Attendance::whereYear('checkin', '=', $date->year)
                                ->whereMonth('checkin', '=', $date->month)
                                ->whereDay('checkin', '=', $date->day)
                                ->where('attendable_id', $id)
                                ->where('attendable_type', $type)
                                ->first();
        if($prev_attendance){
            Attendance::where('id', $prev_attendance->id)->update([
                'attendable_id'     => $id, 
                'attendable_type'   => $type,
                'status'            => $request->status,
                'checkin'           => $request->date,                            
            ]);
        }else{
            Attendance::create([
                'attendable_id'     => $id, 
                'attendable_type'   => $type,
                'status'            => $request->status,
                'checkin'           => $request->date,                            
            ]);
        }

        if($request->type == 'staff'){
            $data = Staff::find($id);
        }else{
            $data = Student::find($id);
        }
        
        return response()->json(['attendance' => new AttendanceResource($data)]);
    }
}
