<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\Controller;
use App\Http\Resources\PayrollResource;
use App\Http\Resources\PayslipResource;
use Illuminate\Http\Request;
use App\Models\Payslip;
use App\Models\Payroll;
use Carbon\Carbon;
use DB;


class PayrollController extends Controller
{
            
    /**
     * get
     *
     * @param  mixed $request
     * @param  mixed $offset
     * @param  mixed $page_size
     * @return void
     */
    public function get(Request $request, $month, $offset, $page_size){

        $date = Carbon::parse($month);
        $keywords = $request->keywords ?? null;        
        $query = Payslip::whereYear('month', '=', $date->year)->whereMonth('month', '=', $date->month);
        
        
        if($keywords){
            $query = $query->where(function($q) use ($keywords) {
                $q->whereHas('payroll', function($q) use($keywords){
                    $q->whereHas('staff', function($q) use($keywords){
                        $q->where(DB::raw("concat(first_name, ' ', last_name)"), 'LIKE', "%".$keywords."%");
                    });                    
                });                
            });
        }
        $total = $query->count();            
        $payroll = $query->skip($offset)->take($page_size)->get();
        return response()->json(['payroll' => PayslipResource::collection($payroll), 'total' => $total]);

    }

    public function employees(Request $request){
        
        $employees = Payroll::all();
        return response()->json(['employees' => PayrollResource::collection($employees)]);
    }
}
