<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Section;
use App\Http\Resources\SectionResource;
use App\Http\Requests\SectionRequest;

class SectionController extends Controller
{
        
    /**
     * get
     *
     * @param  mixed $request
     * @return void
     */
    public function get(Request $request){
        $sections = Section::all();
        return response()->json(['sections' => SectionResource::collection($sections)]);
    }

    
    /**
     * create
     *
     * @param  mixed $request
     * @return void
     */
    public function create(SectionRequest $request){
        
        $section = new Section();
        $section->title = $request->title;        
        $section->description = $request->description;           
        $section->capacity = $request->capacity;             
        $section->save();

        return response()->json([ 'section' => new SectionResource($section) ]);

    }

    
    /**
     * update
     *
     * @param  mixed $request
     * @param  mixed $id
     * @return void
     */
    public function update(SectionRequest $request, $id){
        
        $section = Section::find($id);
        $section->title = $request->title;        
        $section->description = $request->description;           
        $section->capacity = $request->capacity;             
        $section->save();

        return response()->json([ 'section' => new SectionResource($section) ]);

    }
}
