<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Services\UserService;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Department;
use \Milon\Barcode\DNS2D;

class UserController extends Controller{    
    
   
    /**
     * get
     *
     * @return void
     */
    public function get(){
        $users = UserService::get();
        return response()->json([ 'users' => $users ]);
    }
    
    /**
     * create
     *
     * @param  mixed $request
     * @return void
     */
    public function create(UserRequest $request){

        $user = UserService::create($request);
        return response()->json([
            'user' => $user
        ]);
    }


    public function managers(Request $request){

        $managers = UserService::users_by_permissions(['manage campus']);
        return response()->json([
            'users' => $managers
        ]);
    }

    
    /**
     * update
     *
     * @param  mixed $request
     * @param  mixed $id
     * @return void
     */
    public function update(UserRequest $request, $id){
        $user = UserService::update($request, $id);
        return response()->json([ 'user' => $user]);
    }

    
    /**
     * delete
     *
     * @param  mixed $request
     * @param  mixed $id
     * @return void
     */
    public function delete(Request $request, $id){

        $user = UserService::delete($id);        
        return response()->json([
            'id' => intval($id)
        ]);
    }

    
    /**
     * config
     *
     * @param  mixed $request
     * @return void
     */
    public function config(Request $request){
        $config = Config::pluck('value', 'name')->all();
        return response()->json([
            'config' => $config
        ]);
    }

    
    /**
     * get_qrcode
     *
     * @param  mixed $request
     * @return void
     */
    public function get_qrcode(Request $request){
        $d = new DNS2D();        
        // $qrcode = $d->getBarcodePNG('AHE-220001', 'C39');
        $qrcode = $d->getBarcodePNG($request->code, 'QRCODE');
        return response()->json([
            'img' => "data:image/png;base64,".$qrcode
        ]);        
    }
    
    /**
     * get_departments
     *
     * @param  mixed $request
     * @return void
     */
    public function get_departments(Request $request){
        $departments = Department::select('title')->orderBy('title', 'ASC')->get()->pluck('title');
        return response()->json(['departments' => $departments]);
    }

}
