<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Contracts\Auth\Factory as Auth;

class GroupMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */

    protected $auth;

    public function __construct(Auth $auth)
    {
        $this->auth = $auth;
    }


    public function handle($request, Closure $next)
    {
        $roles = array_slice(func_get_args(), 2);
        
        foreach ($roles as $role)
        {
            if ($request->user() && $request->user()->group === trim($role))
            {
                return $next($request);                
            }
        }
        return response(['error' => 'Forbidden'], 403);

        // if ($request->user() && $request->user()->type != 'SUPER_ADMIN')
        // {
        //     return response(['error' => 'Forbidden.'], 403);
        // }
        
    }
}
