<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CampusRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'code'              => 'bail|required|unique:campuses,code,'.$this->id,            
            'title'             => 'bail|required|string',            
            'email'             => 'bail|required|email',
            'address'           => 'bail|required',
            'manager_id'        => 'bail|required',
            'phone'             => 'bail|required',
            'secondary_phone'   => 'bail',                    
            'image'             => 'bail'
        ];
    }
}
