<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FeeInvoiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type'              => 'bail|required|in:INDIVIDUAL,BULK',
            'month'             => 'bail|required',
            'due_date'          => 'bail|required',
            'fee_types'         => 'bail|required',
            'classes'           => 'bail|required',
            'campuses'          => 'bail|required',
            'student_ids'       => 'bail|required_if:type,INDIVIDUAL|array',
            'status'            => 'bail|required',
            'other_charges'     => 'bail',
            'notes'             => 'bail'
        ];
    }
}
