<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AuthResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        if($this->staff){
            return[
                'id'            => $this->id,
                'first_name'    => $this->staff->first_name,            
                'last_name'     => $this->staff->last_name,
                'cnic'          => $this->staff->cnic,
                'email'         => $this->email,
                'contacts'      => $this->staff->contacts,
                'avatar'        => new MediaResource($this->staff->avatar),                
                'code'          => $this->staff->code,
                'title'         => $this->staff->title,
                'department'    => $this->staff->department,
                'updated_at'    => $this->updated_at,                        
                'status'        => $this->status,  
                'permissions'   => $this->userPermissions,
                'sa'            => $this->super_admin
            ];
        }else{
            return[
                'id'            => $this->id,
                'email'         => $this->email,
                'updated_at'    => $this->updated_at,
                'status'        => $this->status,
                'roles'         => $this->role_ids(),
                'sa'            => $this->super_admin         
            ];
        }
    }
}
