<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CampusResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return[
            'id'            => $this->id,
            'title'         => $this->title,            
            'code'          => $this->code,
            'email'         => $this->email,
            'contacts'      => $this->contacts,
            'image'         => new MediaResource($this->image),
            'documents'     => MediaResource::collection($this->documents),           
            'address'       => $this->address,
            'city'          => $this->city,            
            'manager'       => $this->manager,
            'updated_at'    => $this->updated_at   
            
        ];
    }
}
