<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class FeeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'serial'        => $this->serial,
            'month'         => $this->month,                    
            'due_date'      => $this->due_date,
            'charges'       => $this->charges,            
            'status'        => $this->status,
            'method'        => $this->method,
            'balance'       => $this->balance,
            'notes'         => $this->notes,
            'transaction'   => $this->transaction,
            'student'       => new StudentInfoResource($this->student)
        ];
    }
}
