<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MediaResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return[
            'id'            => $this->id,
            'type'          => $this->type,
            'mime'          => $this->file_type,
            'path'          => $this->path,
            'name'          => $this->original_name,
            'size'          => $this->size,
            'updated_at'    => $this->updated_at           
        ];
    }
}
