<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StaffResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        $data = [
            'id'            => $this->id,
            'first_name'    => $this->first_name,            
            'last_name'     => $this->last_name,
            'cnic'          => $this->cnic,                
            'contacts'      => $this->contacts,
            'avatar'        => new MediaResource($this->avatar),
            'documents'     => MediaResource::collection($this->documents),           
            'code'          => $this->code,
            'title'         => $this->title,
            'campus'        => $this->campus,
            'department'    => $this->department,
            'address'       => $this->address,
            'updated_at'    => $this->updated_at,   
        ];
        if($this->user){
            $data['user_id']= $this->user->id;
            $data['status'] = $this->user->status;
            $data['email']  = $this->user->email;
            $data['roles']  = $this->user->role_ids();          
        }
        return $data;
    }
}
