<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $json_data = [
            'id'            => $this->id,
            'email'         => $this->email,
            'updated_at'    => $this->updated_at,
            'status'        => $this->status,
            'roles'         => $this->role_ids()           
        ];

        if($this->staff){
            $json_data['first_name'] = $this->staff->first_name;
            $json_data['last_name']  = $this->staff->last_name;
            $json_data['cnic']  = $this->staff->cnic;
            $json_data['contacts']  = $this->staff->contacts;
            $json_data['avatar']  = new MediaResource($this->staff->avatar);
            $json_data['documents']  = MediaResource::collection($this->staff->documents);
            $json_data['code'] = $this->staff->code;
            $json_data['title'] = $this->staff->title;
            $json_data['department'] = $this->staff->department;            
        }
        return $json_data;
    }
}
