<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Campus extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $fillable = [
        'title',
        'code',
        'contacts',
        'address',
        'city',
        'website',
        'details',
        'manager_id',
    ];
   
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'id'            => 'integer',
        'manager_id'    => 'integer',
        'contacts'      => 'array',
        'details'       => 'array'
    ];

    public function manager(){
        return $this->belongsTo(User::class, 'manager_id', 'id');
    }    

    public function image(){
        return $this->morphOne(Media::class, 'mediable')->where('type', MediaType::IMAGE);
    }

    public function documents(){
        return $this->morphMany(Media::class, 'mediable')->where('type', MediaType::DOC);
    }
}
