<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Log;

class Fee extends Model
{
    use HasFactory, SoftDeletes;


    protected $fillable = [
        'student_id',
        'serial',
        'month',
        'due_date',
        'charges',
        'balance',
        'status',
        'method',
        'notes',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'id'            => 'integer',
        'student_id'    => 'integer',
        'charges'       =>  'array',
        'balance'       =>  'float',        
    ];

   
    
    public function student(){
        return $this->belongsTo(Student::class);
    }

    public function transaction(){
        return $this->morphOne(Transaction::class, 'transactable');
    }

}
