<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payroll extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'staff_id',
        'joined_at',
        'basic_salary',
        'allowances',
        'taxes',
        'status',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'id'        => 'integer',
        'staff_id'  => 'integer',
        'allowances'=> 'array',
        'taxes'     => 'array',
    ];


    public function staff(){
        return $this->belongsTo(Staff::class);
    }

    public function documents(){
        return $this->morphMany(Media::class, 'mediable')->where('type', MediaType::DOC);
    }

}
