<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payslip extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'payroll_id',
        'serial',
        'month',
        'payment_at',
        'payments',
        'deductions',
        'net_amount',
        'notes',
        'status'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'id'            => 'integer',
        'payroll_id'    => 'integer',
        'payments'      => 'array',
        'deductions'    => 'array'
    ];


    public function payroll(){
        return $this->belongsTo(Payroll::class);
    }

}
