<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Staff extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'first_name',
        'last_name',
        'user_id',
        'campus_id',
        'code',
        'cnic',
        'title',
        'address',
        'department',        
        'contacts',
        'status'        
    ];

    protected $casts = [
        'id' => 'integer',
        'contacts' => 'array',
    ];

    public function campus(){
        return $this->belongsTo(Campus::class, 'campus_id', 'id');
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function avatar(){
        return $this->morphOne(Media::class, 'mediable')->where('type', MediaType::AVATAR);
    }

    public function documents(){
        return $this->morphMany(Media::class, 'mediable')->where('type', MediaType::DOC);
    }

    public function attendance(){
        return $this->morphMany(Attendance::class, 'attendable');
    }

}
