<?php 

namespace App\Services;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use App\Models\MediaType;
use App\Models\SourceType;
use App\Models\Media;
use Image;
use Log;

class MediaService{
    
    
    /**
     * create
     *
     * @param  mixed $data
     * @return void
     */
    public function create($data){
        $media = Media::create($data);
        return $media;
    }

    
    /**
     * remove
     *
     * @param  mixed $mediable_id
     * @param  mixed $mediable_type
     * @param  mixed $type
     * @return void
     */
    public function remove($mediable_id, $mediable_type, $type ){
        Media::where('mediable_id', $mediable_id)->where('mediable_type', $mediable_type)->where('type', $type)->delete();
    }

    /**
     * _get_avatar_path
     *
     * @param  mixed $request
     * @return void
     */
    public function get_avatar_path($request){
        $avatar_path = null;              
        if($request->has('avatar') && $request->file('avatar') != null)
        {
            $avatar = $request->file('avatar');
            $imageThumb = Image::make($avatar);  
            $image_thumb = $imageThumb->fit(256,256, function($constraint) {
                $constraint->upsize();
            });
            $extension = $avatar->getClientOriginalExtension();
            $namewithextension = $avatar->getClientOriginalName();                            
            $filename = 'avatar-'.Str::uuid() . '.' . $extension;
            $path = app()->basePath('public/assets/avatars/');
            $image_thumb->save($path . $filename);
            $avatar_path = '/public/assets/avatars/'.$filename;

            $file_type = $avatar->getClientMimeType();
            $data = [
                'name'          =>  $filename,
                'original_name' =>  $namewithextension,
                'path'          =>  $avatar_path,
                'extension'     =>  $extension,
                'type'          =>  MediaType::AVATAR,
                'file_type'     =>  $file_type,
            ];
                    
            return $data;
        }
        return null;
    }
    
    /**
     * _get_image_path
     *
     * @param  mixed $request
     * @return void
     */
    public function get_image_path($request){
        $avatar_path = null;              
        if($request->has('image') && $request->file('image') != null)
        {
            $avatar = $request->file('image');
            $imageThumb = Image::make($avatar);  
            $image_thumb = $imageThumb->fit(256,256, function($constraint) {
                $constraint->upsize();
            });
            $extension = $avatar->getClientOriginalExtension();
            $namewithextension = $avatar->getClientOriginalName();                            
            $filename = 'avatar-'.Str::uuid() . '.' . $extension;
            $path = app()->basePath('public/assets/images/');
            $image_thumb->save($path . $filename);
            $avatar_path = '/public/assets/images/'.$filename;

            $file_type = $avatar->getClientMimeType();
            $data = [
                'name'          =>  $filename,
                'original_name' =>  $namewithextension,
                'path'          =>  $avatar_path,
                'extension'     =>  $extension,
                'type'          =>  MediaType::IMAGE,
                'file_type'     =>  $file_type,
            ];
                    
            return $data;
        }
        return null;
    }

    public function get_documents_path($request){
        $docs = [];
        $exts=['pdf','jpg','png','docx','doc','jpeg','ppt','xlsx','xls'];

        if($request->has('documents') && $request->file('documents') != null){
            $files = $request->file('documents');
            foreach($files as $file){
                $filename = $file->getClientOriginalName();
                $extension = $file->getClientOriginalExtension();
                $new_filename = 'doc-'.Str::uuid().'.'.$extension;
                $check=in_array($extension,$exts);
                if($check){
                    $path = Storage::disk('documents')->putFileAs("/", $file, $new_filename);
                    $file_type = $file->getClientMimeType();
                    $docs[] = [
                        'name'          =>  $new_filename,
                        'original_name' =>  $filename,
                        'path'          =>  Storage::disk('documents')->url($path),
                        'extension'     =>  $extension,
                        'type'          =>  MediaType::DOC,
                        'file_type'     =>  $file_type,
                        'size'          =>  Storage::disk('documents')->size($path),
                    ];
                }
            }
        }

        return $docs;
        
    }
}