<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <style>
            body{
                  font-family: 'inter', sans-serif;
            }
            @page{                
                margin: 0mm 0mm 0mm 0mm;
                font-family: 'inter', sans-serif;               
            }

            
            .front-page{                 
                position: relative;                    
                height: 100%;
                background-image: url('{{ base_path("/public/assets/card-front-bg.png") }}');
                background-image-resize: 4;
            }

            .back-page{                 
                position: relative;                    
                height: 100%;
                background-image: url('{{ base_path("/public/assets/card-back-bg.png") }}');
                background-image-resize: 4;
            }

            .user-info{
                position: absolute;
                left: 0%;
                width: 100%;
                text-align: center;                
                top: 65%;
            
            }
            .username{
                font-size: 8.5pt;
                font-weight: bold;
                letter-spacing: -0.25px;
                margin-bottom: 5px;
            }

            .title{
                font-size: 7.5pt;
                font-weight: normal;
                letter-spacing: -0.25px;
            }

            .avatar-wrapper{                
                position: absolute;
                left: 0;
                width: 100%;
                top: 26%;
                text-align: center;
            }
            .avatar{
                width: 110px;
                height: 110px;
                background-image: url('{{ $avatar }}');
                border-radius: 55px;                                
                margin: auto;
                background-size: 110px 110px;
                background-repeat: no-repeat;
                background-position: center; 
            }

            .avatar-wrapper .avatar img{
                border-radius: 50%;
            }
            .qrcode{
                position: absolute;
                width: 100%;
                left: 0;
                text-align: center;
                bottom: 6%;
            }

        </style>
    </head>
    <body>
        <div class="front-page"></div>    
        <div class="avatar-wrapper">
            <div class="avatar"></div>
        </div>        
        <div class="user-info">
            <div class="username">{{  $name }}</div>
            <div class="title">{{  $title }}</div>
        </div>

        <div class="qrcode">
            <img width="48px" height="auto" src="data:image/png;base64,<?php echo $qrcode; ?>" alt="barcode"   />
        </div>

        
        <div style="page-break-after: always;"></div>

        <div class="back-page"></div>

        
    </body>
</html>
