<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['namespace' => 'API\v1','prefix' => '/v1'], function () {
    Route::get('/', function(){
        return 'Api v1';
    });        

    Route::post('/login', 'AccessTokenController@issueToken');
    Route::post('/oauth/token', 'AccessTokenController@issueToken');
    Route::get('/auth','AuthController@check_auth');
    Route::post('/get-qrcode','UserController@get_qrcode');
    Route::post('/students/import', 'StudentController@import');  

    Route::get('/media/print', 'MediaController@print');

    Route::group(['middleware' => 'auth:api'], function(){

        Route::get('/media/{id}', 'MediaController@get');
        Route::delete('/media/{id}', 'MediaController@delete');

        Route::group(['middleware' => 'group:ADMIN'], function(){            

            Route::get('/role/managers', 'UserController@managers');        
            Route::get('/get-departments', 'UserController@get_departments');        
            Route::get('/users', 'UserController@get');        
            Route::post('/users', 'UserController@create');
            Route::post('/users/{id}', 'UserController@update');
            Route::delete('/users/{id}', 'UserController@delete');

            
            Route::get('/roles', 'RoleController@get');
            Route::get('/roles/resources', 'RoleController@resources');
            Route::post('/roles', 'RoleController@create');
            Route::put('/roles/{id}', 'RoleController@update');
            Route::delete('/roles/{id}', 'RoleController@delete');

            Route::get('/campuses', 'CampusController@get');  
            Route::post('/campuses', 'CampusController@create');      

            Route::get('/sections', 'SectionController@get');  
            Route::post('/sections', 'SectionController@create');  
            Route::put('/sections/{id}', 'SectionController@update');  
            Route::delete('/sections/{id}', 'SectionController@delete');

            Route::get('/grades', 'GradeController@get');  
            Route::post('/grades', 'GradeController@create');  
            Route::put('/grades/{id}', 'GradeController@update');  
            Route::delete('/grades/{id}', 'GradeController@delete');

            Route::get('/sessions', 'SessionController@get');  
            Route::get('/sessions/active', 'SessionController@get_active');  
            Route::post('/sessions', 'SessionController@create');  
            Route::put('/sessions/{id}', 'SessionController@update');  
            Route::delete('/sessions/{id}', 'SessionController@delete');

            Route::post('/students/{offset}/{page_size}', 'StudentController@get');  
            Route::put('/students/fees/{id}', 'StudentController@feeplan');
            Route::post('/students/search', 'StudentController@search');  
            Route::post('/students/{id}', 'StudentController@update');            
            Route::post('/students', 'StudentController@create');  
            Route::delete('/students/{id}', 'StudentController@delete');

            Route::get('/fee-months', 'FeeController@fee_months');  
            Route::get('/fee-types', 'FeeController@fee_types');              
            Route::post('/fees/{month}/{offset}/{page_size}', 'FeeController@get');  
            Route::post('/fees', 'FeeController@create');  
            Route::put('/fees/{id}', 'FeeController@update');  

            
            Route::post('/attendance/{date}/{offset}/{page_size}', 'AttendanceController@get');  
            Route::post('/attendance/{id}', 'AttendanceController@update');  

            Route::post('/payroll/{month}/{offset}/{page_size}', 'PayrollController@get');  
            Route::get('/payroll/list', 'PayrollController@employees');  

            
        });
    });
});
